﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="SolderFeederStationCounters.ascx.vb" Inherits="Web.SolderFeederStationCounters" %>
<%@ Register Src="~/private/stations/base/Sections/ControlMode.ascx" TagName="cu_controlmode" TagPrefix="uc" %>

<asp:UpdatePanel runat="server" ID="UpdatePanelCounters" UpdateMode="Conditional">
    <ContentTemplate>

        <div class="mode-panel">
            <uc:cu_controlmode ID="cu_controlmode" runat="server" Visible="false" />
            <div class="holder">
                <asp:Repeater ID="repeater_puertos" runat="server" OnItemCommand="repeater_puertos_ItemCommand">
                    <HeaderTemplate>
                        <ul class="pagination">
                    </HeaderTemplate>
                    <ItemTemplate>
                        <li class='<%# Eval("State")%>'>
                            <asp:LinkButton ID="btnPuerto" runat="server" CommandArgument='<%# Eval("PortNumber")%>' Visible='<%# Eval("Active")%>'><%# Eval("PortNumber")%> </asp:LinkButton>
                        </li>
                    </ItemTemplate>
                    <FooterTemplate>
                        </ul>
                    </FooterTemplate>
                </asp:Repeater>
                <div class="btn-holder">
                    <asp:LinkButton ID="btn_contglobal" runat="server" CssClass="btn active" CommandName="CONTADOR" CommandArgument="GLOBAL" OnClick="btn_contador_click"><%= CurrentContext.Translator.Translate("COUNTER_GLOBAL")%></asp:LinkButton>
                    <asp:LinkButton ID="btn_contparcial" runat="server" CssClass="btn" CommandName="CONTADOR" CommandArgument="PARCIAL" OnClick="btn_contador_click"><%= CurrentContext.Translator.Translate("COUNTER_PARTIAL")%></asp:LinkButton>
                </div>
            </div>
        </div>
        <div class="parameters-block">
            <ul class="parameters-list" data-area="edit-area">
                <li>
                    <div class="container">
                        <span class="parameter-name"><%= CurrentContext.Translator.Translate("COUNTER_CONNECTED_HOURS")%></span>
                        <asp:Label ID="lblvalue_minconect" CssClass="value" runat="server" Text="0."></asp:Label>
                    </div>
                </li>
                <li>
                    <div class="container">
                        <span class="parameter-name"><%= CurrentContext.Translator.Translate("COUNTER_WORKING_HOURS")%></span>
                        <asp:Label ID="lblvalue_mintrabajo" CssClass="value" runat="server" Text="0."></asp:Label>
                    </div>
                </li>
                <li>
                    <div class="container">
                        <span class="parameter-name"><%= CurrentContext.Translator.Translate("COUNTER_WORK_CYCLES")%></span>
                        <asp:Label ID="lblvalue_WorkCycles" CssClass="value" runat="server" Text="0."></asp:Label>
                    </div>
                </li>
                <li>
                    <div class="container">
                        <span class="parameter-name"><%= CurrentContext.Translator.Translate("COUNTER_SUCTION_CYCLES")%></span>
                        <asp:Label ID="lblvalue_SuctionCycles" CssClass="value" runat="server" Text="0."></asp:Label>
                    </div>
                </li>
            </ul>
            <div class="btn-holder">
                <asp:LinkButton ID="LinkBtnInic" runat="server" CssClass="btn" Visible="false" OnClick="LinkBtnInic_Click"><%= CurrentContext.Translator.Translate("COUNTER_BTN_INIC")%></asp:LinkButton>
            </div>

        </div>

        <!-- Controles ocultos -->
        <asp:HiddenField ID="hdnNumPuertos" runat="server" />
        <asp:HiddenField ID="hdnPortActivo" runat="server" Value="1" />
        <asp:HiddenField ID="hdnTipoContador" runat="server" Value="GLOBAL" />

    </ContentTemplate>
    <Triggers>
        <asp:AsyncPostBackTrigger ControlID="btn_contglobal" EventName="Click" />
        <asp:AsyncPostBackTrigger ControlID="btn_contparcial" EventName="Click" />
        <asp:AsyncPostBackTrigger ControlID="LinkBtnInic" EventName="Click" />
    </Triggers>
</asp:UpdatePanel>

<asp:Timer ID="TimerUpdateCuContadores" runat="server" Interval="30000" OnTick="TimerUpdateCuContadores_Tick" Enabled="false"></asp:Timer>

<asp:UpdateProgress ID="UpdateProgressPanelCounters" runat="server" AssociatedUpdatePanelID="UpdatePanelCounters" DisplayAfter="100">
    <ProgressTemplate>
        <asp:Image ID="img_ajax_loading_MenuStation" runat="server" ImageUrl="~/images/ajax-loading.gif" CssClass="ajax_loading_centered" Style="z-index: 100002;" />
    </ProgressTemplate>
</asp:UpdateProgress>

<ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderCounters" TargetControlID="UpdatePanelCounters" BehaviorID="animation" runat="server">    
<Animations>
    <OnUpdating>
        <Sequence>
            <ScriptAction Script="LockScreen();" />
        </Sequence>
    </OnUpdating>
    <OnUpdated>
        <Sequence>
            <ScriptAction Script="UnlockScreen(); initRefreshFunctions2($('div.ajax-holder'));"  />
        </Sequence>
    </OnUpdated>
</Animations>
</ajaxToolkit:UpdatePanelAnimationExtender>
